% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-run.R
\name{cmd_run}
\alias{cmd_run}
\alias{cmd_help}
\alias{cmd_background}
\title{Execute command}
\usage{
cmd_run(
  command,
  stdout = TRUE,
  stderr = TRUE,
  stdin = TRUE,
  stdout_callback = NULL,
  stderr_callback = NULL,
  timeout = NULL,
  spinner = FALSE,
  verbose = TRUE
)

cmd_help(
  command,
  stdout = TRUE,
  stderr = TRUE,
  stdout_callback = NULL,
  stderr_callback = NULL,
  verbose = TRUE
)

cmd_background(
  command,
  stdout = FALSE,
  stderr = FALSE,
  stdin = NULL,
  verbose = TRUE
)
}
\arguments{
\item{command}{A \code{command} object.}

\item{stdout, stderr}{Specifies how the output/error streams of the child
process are handled. Possible values include:
\itemize{
\item \code{FALSE}/\code{NULL}: Suppresses the output/error stream.
\item \code{TRUE}: Prints the child process output/error to the R console. If a
standard output/error stream exists, \code{""} is used; otherwise, \code{"|"} is
used.
\item \strong{string}: An empty string \code{""} inherits the standard output/error stream
from the main R process (Printing in the R console). If the main R process
lacks a standard output/error stream, such as in \code{RGui} on Windows, an
error is thrown. A string \code{"|"} prints to the standard output connection
of R process (Using \code{\link[=cat]{cat()}}). Alternative, a file name or path to
redirect the output/error. If a relative path is specified, it remains
relative to the current working directory, even if a different directory
is set using \code{\link[=cmd_wd]{cmd_wd()}}.
\item \code{connection}: A writable R \code{\link{connection}} object. If the connection is not
\code{\link[=open]{open()}}, it will be automatically opened.
}

For \code{stderr}, use string \code{"2>&1"} to redirect it to the same connection (i.e.
pipe or file) as \code{stdout}.

For \code{cmd_help()}, use \code{FALSE}/\code{NULL} will do nothing, since it always want to
display the help document.

For \code{cmd_background()}, \code{connection} cannot be used, and \code{TRUE} and \code{"|"}
will fallback to the empty string \code{""}.

When using a \code{connection} (if not already open) or a \code{string}, wrapping it
with \code{\link[=I]{I()}} prevents overwriting existing content.}

\item{stdin}{should the input be diverted? Possible values include:
\itemize{
\item \code{FALSE}/\code{NULL}: no standard input.
\item \code{TRUE}: If a standard input stream exists, \code{""} is used; otherwise, \code{NULL}
is used.
\item \strong{string}: An empty string \code{""} inherits the standard input stream from
the main R process. If the main R process lacks a standard input stream,
such as in \code{RGui} on Windows, an error is thrown. Alternative, a file name
or path to redirect the input. If a relative path is specified, it remains
relative to the current working directory, even if a different directory
is set using \code{\link[=cmd_wd]{cmd_wd()}}.
}}

\item{stdout_callback, stderr_callback}{Possible values include:
\itemize{
\item \code{NULL}: no callback function.
\item \code{function}: A function invoked for each line of standard output or error.
Non-text (non-character) output will be ignored. The function should accept
two arguments: one for the standard output or error and another for the
running \code{\link[processx:process]{process}} object.
}}

\item{timeout}{Timeout in seconds. This is a limit for the elapsed time
running command in the separate process.}

\item{spinner}{Whether to show a reassuring spinner while the process
is running.}

\item{verbose}{A single boolean value indicating whether the command
execution should be verbose.}
}
\value{
\itemize{
\item \code{cmd_run}: Exit status invisiblely.
}

\itemize{
\item \code{cmd_help}: The input \code{command} invisiblely.
}

\itemize{
\item \code{cmd_background}: A \code{\link[processx:process]{process}} object.
}
}
\description{
\itemize{
\item \code{cmd_run}: Run the command.
\item \code{cmd_help}: Print the help document for this command.
\item \code{cmd_background}: Run the command in the background. This function is
provided for completeness. Instead of using this function, we recommend
using \code{\link[=cmd_parallel]{cmd_parallel()}}, which can run multiple commands in the background
while ensuring that all processes are properly cleaned up when the process
exits.
}
}
\seealso{
\itemize{
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}
}
