% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-parallel.R
\name{cmd_parallel}
\alias{cmd_parallel}
\title{Execute a list of commands}
\usage{
cmd_parallel(
  ...,
  stdouts = FALSE,
  stderrs = FALSE,
  stdins = NULL,
  stdout_callbacks = NULL,
  stderr_callbacks = NULL,
  timeouts = NULL,
  threads = NULL,
  verbose = TRUE
)
}
\arguments{
\item{...}{A list of \code{command} object.}

\item{stdouts, stderrs}{Specifies how the output/error streams of the child
process are handled. One of or a list of following values:
\itemize{
\item \code{FALSE}/\code{NULL}: Suppresses the output/error stream.
\item \code{TRUE}: Prints the child process output/error to the R console. If a
standard output/error stream exists, \code{""} is used; otherwise, \code{"|"} is
used.
\item \strong{string}: An empty string \code{""} inherits the standard output/error stream
from the main R process (Printing in the R console). If the main R process
lacks a standard output/error stream, such as in \code{RGui} on Windows, an
error is thrown. A string \code{"|"} prints to the standard output connection
of R process (Using \code{\link[=cat]{cat()}}). Alternative, a file name or path to
redirect the output/error. If a relative path is specified, it remains
relative to the current working directory, even if a different directory
is set using \code{\link[=cmd_wd]{cmd_wd()}}.
\item \code{connection}: A writable R \code{\link{connection}} object. If the connection is not
\code{\link[=open]{open()}}, it will be automatically opened.
}

For \code{stderrs}, use string \code{"2>&1"} to redirect it to the same connection
(i.e.  pipe or file) as \code{stdout}.

When a single file path is specified, the stdout/stderr of all commands will
be merged into this single file.}

\item{stdins}{should the input be diverted? One of or a list of following
values:
\itemize{
\item \code{FALSE}/\code{NULL}: no standard input.
\item \code{TRUE}: If a standard input stream exists, \code{""} is used; otherwise, \code{NULL}
is used.
\item \strong{string}: An empty string \code{""} inherits the standard input stream from
the main R process. If the main R process lacks a standard input stream,
such as in \code{RGui} on Windows, an error is thrown. Alternative, a file name
or path to redirect the input. If a relative path is specified, it remains
relative to the current working directory, even if a different directory
is set using \code{\link[=cmd_wd]{cmd_wd()}}.
}}

\item{stdout_callbacks, stderr_callbacks}{One of or a list of following
values:
\itemize{
\item \code{NULL}: no callback function.
\item \code{function}: A function invoked for each line of standard output or error.
Non-text (non-character) output will be ignored. The function should accept
two arguments: one for the standard output or error and another for the
running \code{\link[processx:process]{process}} object.
}}

\item{timeouts}{Timeout in seconds. Can be a single value or a list,
specifying the maximum elapsed time for running the command in the separate
process.}

\item{threads}{Number of threads to use.}

\item{verbose}{A single boolean value indicating whether the command
execution should be verbose.}
}
\value{
A list of exit status invisiblely.
}
\description{
Execute a list of commands
}
\seealso{
\itemize{
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}
}
