% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betagrid.R
\name{betagrid}
\alias{betagrid}
\title{betagrid: Calculates Beta Diversity for all the Grid Cells in Comparison with Their Nearest Neighbor Cells}
\usage{
betagrid(
  gridshp,
  comp,
  xfeature,
  yfeature,
  radius,
  phylotree,
  phylobeta = F,
  index = "sorensen"
)
}
\arguments{
\item{gridshp}{Gridded Shapefile ("SpatialPolygonsDataFrame").}

\item{comp}{community data matrix (species occurrence on each grid cell).}

\item{xfeature}{number of the feature within the gridded shapefile corresponding to the longitude.}

\item{yfeature}{number of the feature within the grid shapefile corresponding to the latitude.}

\item{radius}{the radius (in degrees) that define the maximum distance to select neighbor cells (for example, use the resolution of the gridded shapefile).}

\item{phylotree}{optional phylogenetic tree ("phylo" class). It can also be a "phylo" class functional dendrogram.}

\item{phylobeta}{Optional boolean whether or not to calculate or not phylogenetic beta diversity (see "phylo.beta.pair" function in "betapart" package) instead of the usual beta diversity (see "beta.pair" function in "betapart" package). Default is F.}

\item{index}{to calculate "sorensen" or "jaccard". Default is "sorensen".}
}
\value{
A data frame with values of mean turnover, mean nestedness, and mean beta diversity for each grid cell.
}
\description{
Uses a 'gridded' shapefile and its corresponding community data matrix to calculate beta diversity for each focal grid cell in relation to its neighbor cells (for example, 8 nearest neighbors).
}
\examples{
# https://rfunctions.blogspot.com/2015/08/calculating-beta-diversity-on-grid.html
}
