% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProtocolTable.R
\name{getProtocolTable}
\alias{getProtocolTable}
\title{Get BirdScan protocol table}
\usage{
getProtocolTable(dbConnection, dbDriverChar)
}
\arguments{
\item{dbConnection}{a valid  database connection}

\item{dbDriverChar}{the name of the driver. If different from 'PostgreSQL'
it connects to cloud.birdradar.com}
}
\value{
A dataframe with the protocol table
}
\description{
load protocol table from an already connected 'Birdscan MR1' 'SQL' database
}
\examples{
\dontrun{
# Set server and database settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"

# Open the connection with the database
# ===========================================================================
  dsn = paste0("driver=", dbDriverChar, ";server=", dbServer,
               ";database=", dbName,
               ";uid=", rstudioapi::askForPassword("Database user"),
               ";pwd=", rstudioapi::askForPassword("Database password"))
  dbConnection = RODBC::odbcDriverConnect(dsn)

protocolTable = getProtocolTable(dbConnection, dbDriverChar)
}

}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com};
Birgen Haest, \email{birgen.haest@vogelwarte.ch}
}
