% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specLvlGraph.r
\name{specLvlGraph}
\alias{specLvlGraph}
\title{Spectrum Level Graph and Marine Noise Level}
\usage{
specLvlGraph(freqBand, shipT = -1, seaState = -1, wSpeed = 0, boolR = TRUE)
}
\arguments{
\item{freqBand}{The frequency band of interest}

\item{shipT}{The intensity ship traffic in the area
* 1 - 2 low ship traffic
* 3-4-5 standard ship traffic
* 6 - 7 heavy ship traffic
* 8 - 9 intense ship traffic}

\item{seaState}{The sea state as specified by the National Weather Service}

\item{wSpeed}{The wind speed in miles per hour (mph)}

\item{boolR}{Boolean of whether you want the value printed out in a string. Should be true for HW problems.}
}
\value{
The noise level (NL) in dB re. 1 microPa
}
\description{
This function calculates the ambient noise level (NL; dB re. 1 microPa) in a deep-water marine environement.
}
\examples{
specLvlGraph(c(28,33), ship=4,seaState = 1, wSpeed = 10, boolR = TRUE)

}
\references{
Wenz, G. M. (1962). Acoustic ambient noise in the ocean: Spectra and sources. The Journal of the Acoustical Society of America, 34(12), 1936-1956.

Urick, R. J. (1975). Principles of underwater sound v.2.

Zimmer, W. M. (2011). Passive acoustic monitoring of cetaceans. Cambridge University Press.
}
\author{
Matthew Duggan, K. Lisa Yang Center for Conservation Bioacoustics, Cornell University.
}
