% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{PoissonBlocVisuResum}
\alias{PoissonBlocVisuResum}
\title{PoissonBlocVisuResum function  for visualization of contingency datasets}
\usage{
PoissonBlocVisuResum(x,v,w)
}
\arguments{
\item{x}{contingency matrix of observations.}

\item{v}{a numeric vector specifying the class of rows.}

\item{w}{a numeric vector specifying the class of columns.}
}
\value{
a \pkg{plot} object.
}
\description{
Produce a plot object representing the resumed co-clustered data-sets.
}
\examples{
require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
PoissonBlocVisuResum(data$x,data$xrow,data$xcol)
}
