% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{MI_simple}
\alias{MI_simple}
\title{MI_simple function for agreement between two partitions}
\usage{
MI_simple(v,vprime)
}
\arguments{
\item{v}{numeric vector  specifying the class of observations.}

\item{vprime}{numeric vector specifying another partitions of observations.}
}
\value{
the value of the index.
}
\description{
Produce a measure of agreement between two partitions.(between 0 and 1). A value of 1 corresponds to a perfect match.
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,4,4,4,init_choice='random')
mi=MI_simple(res@model_max$v, data$xrow)
mi
mw=MI_simple(res@model_max$w, data$xcol)}

}
\references{
Robert, Vasseur and Brault. Comparing high-dimensional partitions with the Co-clustering Adjusted Rand Index. Journal of
Classification (2021).
}
