% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_tree_plot.R
\name{bfa_tree_plot}
\alias{bfa_tree_plot}
\title{Plotting Bifurcating Autoregressive Trees}
\usage{
bfa_tree_plot(
  z,
  digits,
  shape = "none",
  vertex.size = 10,
  text.size = 1,
  text.color = "black",
  vertex.color = "gold",
  vertex.asp = 0.25,
  arrow.size = 0.5,
  arrow.width = 0.5,
  arrow.color = "black",
  plot.margin = -0.3
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{digits}{an integer indicating the number of decimal places to be
displayed in vertex labels}

\item{shape}{the shape of the vertex. Currently “circle”, “square”,
“csquare”, “rectangle”, “crectangle”, “vrectangle”, and “none” are
supported. Defaults to “none” which does not display the vertices at all.}

\item{vertex.size}{a numeric scalar or vector defining the size of the vertex
or vertices. If a vector is supplied, vertex sizes may differ. Defaults to
10.}

\item{text.size}{the font size of vertex labels. Defaults to 1.}

\item{text.color}{the color of vertex labels. If it is a character vector,
then it may either contain integer values, named colors or RGB specified
colors with three or four bytes. Defaults to "black".}

\item{vertex.color}{the fill color of the vertex. If you don't want some or
all vertices to have any color, supply NA. The default is "gold". See also
the options in \code{text.color}.}

\item{vertex.asp}{a parameter that controls the aspect ratio of the plot, The default value is 0.25.}

\item{arrow.size}{the size of the arrows. The default value is 0.5.}

\item{arrow.width}{the width of the arrows. The default value is 0.5.}

\item{arrow.color}{the color of the arrows. The default is "black". See also
the options in \code{text.color}.}

\item{plot.margin}{the amount of empty space around the plot, it is a numeric
vector of length four. Usually values between 0 and 0.5 are meaningful, but
negative values are also possible and in that case it will make the plot
zoom in to a part of the graph. If it is shorter than four, recycling will
occur. The default value is -0.3.}
}
\value{
A binary tree displaying the BFA data.
}
\description{
This function graphs bifurcating autoregressive (BFA) tree data.
}
\details{
For more details about the graph options see
\code{\link[igraph]{igraph.plotting}}.
}
\examples{
z <- bfa_tree_gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa_tree_plot(z)
bfa_tree_plot(z,shape= "circle")
bfa_tree_plot(z,shape= "circle", text.color="white", vertex.color = "darkgrey",plot.margin = 0)
}
