% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bell.R
\name{bell}
\alias{bell}
\title{Family Objects for Models}
\usage{
bell(link = "log")
}
\arguments{
\item{link}{a specification for the model link function.  This can be
    a name/expression, a literal character string, a length-one character
    vector, or an object of class
    \code{"\link[stats:make.link]{link-glm}"} (such as generated by
    \code{\link[stats]{make.link}}) provided it is not specified
    \emph{via} one of the standard names given next.

    The \code{gaussian} family accepts the links (as names)
    \code{identity}, \code{log} and \code{inverse};
    the \code{binomial} family the links \code{logit},
    \code{probit}, \code{cauchit}, (corresponding to logistic,
    normal and Cauchy CDFs respectively) \code{log} and
    \code{cloglog} (complementary log-log);
    the \code{Gamma} family the links \code{inverse}, \code{identity}
     and \code{log};
    the \code{poisson} family the links \code{log}, \code{identity},
    and \code{sqrt}; and the \code{inverse.gaussian} family the links
    \code{1/mu^2}, \code{inverse}, \code{identity}
    and \code{log}.

    The \code{quasi} family accepts the links \code{logit}, \code{probit},
    \code{cloglog},  \code{identity}, \code{inverse},
    \code{log}, \code{1/mu^2} and \code{sqrt}, and
    the function \code{\link[stats]{power}} can be used to create a
    power link function.
  }
}
\value{
An object of class \code{"family"} (which has a concise print method).
  This is a list with elements
  \item{family}{character: the family name.}
  \item{link}{character: the link name.}
  \item{linkfun}{function: the link.}
  \item{linkinv}{function: the inverse of the link function.}
  \item{variance}{function: the variance as a function of the mean.}
  \item{dev.resids}{function giving the deviance for each observation
    as a function of \code{(y, mu, wt)}, used by the
    \code{\link[stats:residuals.glm]{residuals}} method when computing
    deviance residuals.}
    \item{aic}{function giving the AIC value if appropriate (but \code{NA}
    for the quasi- families).  More precisely, this function
    returns \eqn{-2\ell + 2 s}{-2 ll + 2 s}, where \eqn{\ell}{ll} is the
    log-likelihood and \eqn{s} is the number of estimated scale
    parameters.  Note that the penalty term for the location parameters
    (typically the \dQuote{regression coefficients}) is added elsewhere,
    e.g., in \code{\link[stats]{glm.fit}()}, or \code{\link[stats]{AIC}()}, see the
    AIC example in \code{\link[stats]{glm}}.
    See \code{\link[stats]{logLik}} for the assumptions made about the
    dispersion parameter.}
  \item{mu.eta}{function: derivative of the inverse-link function
    with respect to the linear predictor.  If the inverse-link
    function is \eqn{\mu = g^{-1}(\eta)}{mu = ginv(eta)} where
    \eqn{\eta}{eta} is the value of the linear predictor, then this
    function returns
    \eqn{d(g^{-1})/d\eta = d\mu/d\eta}{d(ginv(eta))/d(eta) = d(mu)/d(eta)}.}
  \item{initialize}{expression.  This needs to set up whatever data
    objects are needed for the family as well as \code{n} (needed for
    AIC in the binomial family) and \code{mustart} (see \code{\link[stats]{glm}}).}
  \item{validmu}{logical function.  Returns \code{TRUE} if a mean
    vector \code{mu} is within the domain of \code{variance}.}
  \item{valideta}{logical function.   Returns \code{TRUE} if a linear
    predictor \code{eta} is within the domain of \code{linkinv}.}
  \item{simulate}{(optional) function \code{simulate(object, nsim)} to be
    called by the \code{"lm"} method of \code{\link[stats]{simulate}}.  It will
    normally return a matrix with \code{nsim} columns and one row for
    each fitted value, but it can also return a list of length
    \code{nsim}. Clearly this will be missing for \sQuote{quasi-}
    families.}
  \item{dispersion}{(optional since \R version 4.3.0) numeric: value of the
    dispersion parameter, if fixed, or \code{NA_real_} if free.}
}
\description{
Family objects provide a convenient way to specify the details of the
  models used by functions such as \code{\link[stats]{glm}}.  See the
  documentation for \code{\link[stats]{glm}} for the details on how such model
  fitting takes place.
}
\details{
\code{family} is a generic function with methods for classes
  \code{"glm"} and \code{"lm"} (the latter returning \code{gaussian()}).


  For the \code{binomial} and \code{quasibinomial} families the response
  can be specified in one of three ways:
  \enumerate{
    \item As a factor: \sQuote{success} is interpreted as the factor not
    having the first level (and hence usually of having the second level).
    \item As a numerical vector with values  between \code{0} and
    \code{1}, interpreted as the proportion of successful cases (with the
    total number of cases given by the \code{weights}).
    \item As a two-column integer matrix: the first column gives the
    number of successes and the second the number of failures.
  }

  The \code{quasibinomial} and \code{quasipoisson} families differ from
  the \code{binomial} and \code{poisson} families only in that the
  dispersion parameter is not fixed at one, so they can model
  over-dispersion.  For the binomial case see
  McCullagh and Nelder (1989, pp.\ifelse{latex}{\out{~}}{ }{}124--8).
  Although they show that there is (under some
  restrictions) a model with
  variance proportional to mean as in the quasi-binomial model, note
  that \code{glm} does not compute maximum-likelihood estimates in that
  model.  The behaviour of S is closer to the quasi- variants.
}
\note{
The \code{link} and \code{variance} arguments have rather awkward
  semantics for back-compatibility.  The recommended way is to supply
  them as quoted character strings, but they can also be supplied
  unquoted (as names or expressions).  Additionally, they can be
  supplied as a length-one character vector giving the name of one of
  the options, or as a list (for \code{link}, of class
  \code{"link-glm"}).  The restrictions apply only to links given as
  names: when given as a character string all the links known to
  \code{\link[stats]{make.link}} are accepted.

  This is potentially ambiguous: supplying \code{link = logit} could mean
  the unquoted name of a link or the value of object \code{logit}.  It
  is interpreted if possible as the name of an allowed link, then
  as an object.  (You can force the interpretation to always be the value of
  an object via \code{logit[1]}.)
}
\examples{
library(bellreg)
data(faults)
fit <- glm(nf ~ lroll, data = faults, family = bell("log"))
summary(fit)

}
\references{
McCullagh P. and Nelder, J. A. (1989)
  \emph{Generalized Linear Models.}
  London: Chapman and Hall.

  Dobson, A. J. (1983)
  \emph{An Introduction to Statistical Modelling.}
  London: Chapman and Hall.

  Cox, D. R. and  Snell, E. J. (1981).
  \emph{Applied Statistics; Principles and Examples.}
  London: Chapman and Hall.

  Hastie, T. J. and Pregibon, D. (1992)
  \emph{Generalized linear models.}
  Chapter 6 of \emph{Statistical Models in S}
  eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link[stats]{glm}}, \code{\link[stats]{power}}, \code{\link[stats]{make.link}}.

  For binomial \emph{coefficients}, \code{\link{choose}};
  the binomial and negative binomial \emph{distributions},
  \code{\link[stats]{Binomial}}, and \code{\link[stats]{NegBinomial}}.
}
\author{
The design was inspired by S functions of the same names described
  in Hastie & Pregibon (1992) (except \code{quasibinomial} and
  \code{quasipoisson}).
}
