% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIBERlite.R
\name{CIBERlite}
\alias{CIBERlite}
\title{CIBERlite}
\usage{
CIBERlite(
  data,
  determinants,
  targets,
  determinantOrder = NULL,
  determinantLabels = NULL,
  subDeterminantLabels = NULL,
  title = NULL,
  conf.level = 0.95,
  scaleRange = NULL,
  determinantAesthetics = list(fill = "black", color = NA, alpha = 0.5),
  subDeterminantAesthetics = list(fill = "black", color = NA, alpha = 0.5),
  rDiamondAesthetics = list(fill = "#c4c4c4", color = NA, alpha = 0.75)
)
}
\arguments{
\item{data}{The dataframe containing the variables.}

\item{determinants}{Either a character vector with the names of the
determinants, or a list of named character vectors, where each vector
contains a number of subdeterminants, and each vector's name is the name
of the more proximal determinant (i.e. that 'contains' those subdeterminants).}

\item{targets}{A character vector with the names of the targets (i.e. more
proximal determinants, behavior, etc).}

\item{determinantOrder}{The order in which to display the determinants (if
this needs to be different from the order as provided in \code{determinants}).}

\item{determinantLabels}{The labels to use for the determinants.}

\item{subDeterminantLabels}{The labels to use for the subdeterminants.}

\item{title}{The title of the plot.}

\item{conf.level}{The confidence levels: a list with two named values; the
confidence level for the means, named \code{means}, and the confidence level
for the associations, named \code{associations}.}

\item{scaleRange}{The full range of the scale of the
determinants/subdeterminants; the minimum and maximum values are used if
this is not provided.}

\item{determinantAesthetics, subDeterminantAesthetics, rDiamondAesthetics}{The
aesthetics for the determinants, subdeterminants, and correlation diamonds,
each a list containing three named values: \code{fill}, \code{color}, and \code{alpha}.}
}
\value{
A \code{ggplot}.
}
\description{
CIBERlite plots can be used to quickly get an idea of means and correlations
of a small number of determinants. They were developed to facilitate
conducting and interpreting determinant studies by prevention
professionals.
}
\details{
More details are provided in \url{doi:10/js9b}.
}
\examples{
### This example uses the determinant study Party Panel 15.1;
### see ?behaviorchange::BBC_data for more information.
data(BBC_pp15.1);
CIBERlite(data=BBC_pp15.1,
          determinants=c('highDose_attitude',
                         'highDose_perceivedNorm',
                         'highDose_pbc'),
          targets=c('highDose_intention'));

}
