% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_gamma_distr}
\alias{create_gamma_distr}
\alias{create_distr_gamma}
\title{Create a gamma distribution}
\usage{
create_gamma_distr(
  id = NA,
  alpha = 0.5396,
  beta = 0.3819,
  value = NA,
  lower = NA,
  upper = NA
)
}
\arguments{
\item{id}{the distribution's ID}

\item{alpha}{the alpha shape parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_alpha_param}}}

\item{beta}{the beta shape parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_beta_param}}}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
a gamma distribution
}
\description{
Create a gamma distribution
}
\examples{
if (is_on_ci()) {

  gamma_distr <- create_gamma_distr(
    alpha = 0.05,
    beta = 10.0
  )

  gtr_site_model <- create_gtr_site_model(
    rate_ac_prior_distr = gamma_distr
  )

  beast2_input_file <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    site_model = gtr_site_model
  )
  file.remove(beast2_input_file)

  remove_beautier_folder()
}
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
