% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{bdsvd.structure}
\alias{bdsvd.structure}
\title{Data Matrix Structure According to the Detected Block Structure.}
\usage{
bdsvd.structure(X, block.structure, output = "matrix", block.order)
}
\arguments{
\item{X}{Data matrix of dimension \eqn{n x p} with possibly \eqn{p >> n}.}

\item{block.structure}{Output of \code{bdsvd()} or \code{single.bdsvd()} which identified the block structure.}

\item{output}{Should the output be the data matrix ordered according to the blocks (\code{"matrix"}), or
a list containing the submatrices (\code{"submatrices"}). Default is \code{"matrix"}.}

\item{block.order}{A vector that contains the order of the blocks detected by \code{bdsvd()} or \code{single.bdsvd()}.
The vector must contain the index of each blocks exactly once. Default is \code{1:b} where \code{b} is the total number of blocks.}
}
\value{
Either the data matrix \code{X} with columns sorted according to the detected blocks, or a list containing the detected
submatrices.
}
\description{
Either sorts the data matrix \eqn{X} according to the detected block structure \eqn{X_1 , ... , X_b}, ordered by the number
of variables that the blocks contain. Or returns the detected submatrices each individually in a list object.
}
\examples{
#Toying with the illustrative example from Bauer (2024).


p <- 150 #Number of variables. In Bauer (2024), p = 3000.
n <- 500 #Number of observations
b <- 3   #Number of blocks
design <- "c"

#Simulate data matrix X
set.seed(1)
Sigma <- bdsvd.cov.sim(p = p, b = b, design = design)
X <- mvtnorm::rmvnorm(n, mean = rep(0, p), sigma = Sigma)
colnames(X) <- seq_len(p)

#Compute iterative BD-SVD
bdsvd.obj <- bdsvd(X, standardize = FALSE)

#Obtain the data matrix X, sorted by the detected blocks
colnames(bdsvd.structure(X, bdsvd.obj, output = "matrix") )
colnames(bdsvd.structure(X, bdsvd.obj, output = "matrix", block.order = c(2,1,3)) )

#Obtain the detected submatrices X_1, X_2, and X_3
colnames(bdsvd.structure(X, bdsvd.obj, output = "submatrices")[[1]] )
colnames(bdsvd.structure(X, bdsvd.obj, output = "submatrices")[[2]] )
colnames(bdsvd.structure(X, bdsvd.obj, output = "submatrices")[[3]] )

}
\references{
\cite{Bauer, J.O. (2024). High-dimensional block diagonal covariance structure detection using singular vectors, J. Comput. Graph. Stat.}
}
\seealso{
\code{\link{bdsvd}}, \code{\link{single.bdsvd}}
}
