% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.R
\name{bdribs.contour}
\alias{bdribs.contour}
\title{contour plot - draws plot (optional) and returns a matrix/grid of posterior values}
\usage{
bdribs.contour(ymax, pyrmax, eincr, tol, k, bg.rate, plt = TRUE, ...)
}
\arguments{
\item{ymax}{maximum number of AESI event for which contour plot to be drawn}

\item{pyrmax}{maximum risk exposure (in patient-year)}

\item{eincr}{increment of patient-year exposures (default = 50)}

\item{tol}{the maximum tolerance value of relative risk r (default =1)}

\item{k}{allocation ratio (T:C)}

\item{bg.rate}{estimated background rate (historical control rate) per patient-year (using inf.type=1)}

\item{plt}{whether a contour plot to be drawn (default = TRUE)}

\item{...}{to supply remaining parameters for bdribs call when supplied will override the default values}
}
\value{
returns contour plot matrix over the grid specified
}
\description{
Contour plot of posterior probabilities on a range of (y, E) values
}
\examples{
## Sample calls
     #run 1: The contour plot
     \donttest{
     bdribs.contour(ymax=15,pyrmax=2000,eincr=250,tol=1.5,k=2, bg.rate=0.0045)
     #run 2: Monitoring blinded AE over time using contour plot
     bdribs.contour(ymax=15,pyrmax=2000,eincr=250,tol=1.5,k=2, bg.rate=0.0045)
     obs.pyr=c(300,570,650,800, 1200, 1500)
     obs.y=c(2,4,5,6,10,12)
     points(obs.pyr, obs.y,type="p",pch=16, cex=1.4,col="maroon")
     if (length(obs.y)>1) points(c(0,obs.pyr), c(0,obs.y), type="s", lty=3, lwd=2,
     col="black")
     }
}
