% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEPRECATED.R
\name{bdotsRefit}
\alias{bdotsRefit}
\title{Refit Observations Returned from bdotsFit}
\usage{
bdotsRefit(
  bdObj,
  fitCode = 1L,
  subset = NULL,
  quickRefit = FALSE,
  numRefits = 2L,
  paramDT = NULL,
  ...
)
}
\arguments{
\item{bdObj}{An object of class 'bdotsObj' returned from \code{bdotsFit}}

\item{fitCode}{A length one integer indicating observations to refit. See Details}

\item{subset}{Either an expression that evaluates to a logical used to subset the \code{bdObj},
(using \code{data.table} syntax) or a numeric vector of indices to subset. Default is \code{NULL}.
When not \code{NULL}, any arguments to \code{fitCode} are ignored.}

\item{quickRefit}{Boolean indicating if a quick refit should be used. If TRUE,
rather than prompting the user for adjustments for each observation, \code{bdotsReft}
will jitter the parameters of all observations indicated by \code{fitCode} and attempt
to refit. Between the original and the refitted curve, this will place priority on
the higher \code{fitCode}. If these are equal, R2 will take precedence. Otherwise,
the original fit will be kept.}

\item{numRefits}{Integer indicating the number of refit attempts after jittering
parameters, either with quickRefit or when done individually}

\item{paramDT}{A \code{data.table} or \code{data.frame} that matches the what is
returned by \code{coefWriteout(bdObj)}. That is, it should have columns
uniquely identifying observations with subjects and groups, as well as named
columns for the paramters. NA parameters are OK. Can also be a subset of the original rows.
Note, if this argument is not \code{NULL}, the remaining arguments will be ignored.}

\item{...}{not used}
}
\value{
Returns bdObj with updated fits
}
\description{
DEPRECATED. Use \code{brefit} instead
}
\details{
DEPRECATED. Use \code{brefit} instead
}
