\name{bdf3.mep}
\alias{bdf3.mep}

\title{
Efficient Block Designs for 3-Level Factorial Experiments in Block Size 3
}

\description{
Constructs efficient block designs for 3-level factorial experiments in block size 3, ensuring estimation of all main effects and two-factor interactions.
}

\usage{
bdf3.mep(n_factors, show_efficiency = TRUE)
}

\arguments{
  \item{n_factors}{
    An integer specifying the number of factors.
  }
  \item{show_efficiency}{
    Logical. If \code{TRUE}, efficiency factors are computed and displayed; if \code{FALSE}, they are omitted.
  }
}

\details{
This function generates efficient block designs for 3-level factorial experiments in block size 3. The resulting designs allow estimation of all main effects and two-factor interactions in minimum number of replications.
}

\value{
A list containing:
  \item{blocks}{The chosen principal blocks}
  \item{confounded_effects}{The confounded main effects and two-factor interactions}
  \item{efficiency_factors}{Efficiency factors of all main effects and two-factor interactions (if \code{show_efficiency = TRUE})}
  \item{design}{The final block design for the given number of factors}
}

\references{
Dey, A. and Mukerjee, R. (2012). Efficiency factors for natural contrasts in partially confounded factorial designs. \emph{Statistics and Probability Letters}, 82(12), 2180--2188. <doi:10.1016/j.spl.2012.06.014>

Dash, S., Parsad, R. and Gupta, V. K. (2013). Row–column designs for 2^n factorial 2-colour microarray experiments for estimation of main effects and two-factor interactions with orthogonal parameterization. \emph{Agricultural Research}, 2(2), 172-182. <doi:10.1007/s40003-013-0059-5>
}

\seealso{
\code{\link{bdf3.mef}}
}

\examples{
bdf3.mep(2)
}
