% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbmix.R
\name{call_gt}
\alias{call_gt}
\title{Call genotypes using beta binomial after model training}
\usage{
call_gt(
  allele_counts_f,
  depth = 10,
  stan_f = NULL,
  legend_f,
  pop = "EUR",
  prob = 0.99,
  fisher_f = NULL,
  fisher = 30,
  cluster_f = NULL,
  out
)
}
\arguments{
\item{allele_counts_f}{vector with file names with allele counts for SNPs}

\item{depth}{min read count to call variant}

\item{stan_f}{full name to stan object with model fit to extract mean of parameters. Defaults to the model trained with genome in a bottle reads. Otherwise this object can be generated with fit_bb function.}

\item{legend_f}{full name for file with SNP info to get allele frequency for prior}

\item{pop}{population to select AF for GT prior, defaults to EUR}

\item{prob}{cut-off for making hard calls, defaults to 0.99}

\item{fisher_f}{file with Fisher test to detect strand bias}

\item{fisher}{cut_off for Fisher test to detect strand bias}

\item{cluster_f}{file with info about SNP clusters}

\item{out}{character with file name to save genotype output}
}
\value{
data table with genotype probabilities
}
\description{
Call genotypes using beta binomial after model training
}
\examples{
## Retrive input files for running call_gt
counts_f <- system.file("extdata/input", "NA12878.chr22.Q20.allelicCounts.txt",
package = "bbmix",
mustWork = TRUE)

legend <- system.file("extdata/input", "1000GP_Phase3_chr22.legend",
package = "bbmix", mustWork = TRUE)

fisher_f <- system.file("extdata/input", "chr22.FS.Q20.alleleCounts.txt",
package = "bbmix", mustWork = TRUE)

cluster_f <- system.file("extdata/input", "fSNPs_22_RP_maf0_01_cluster3window35.txt",
package = "bbmix", mustWork = TRUE)

out <- paste0(tempdir() , "/NA12878.chrom22.gt.txt")

## Run call_gt:
call_gt(allele_counts_f = counts_f,
legend_f = legend,
fisher_f = fisher_f,
cluster_f = cluster_f,
out = out)

unlink(out)

}
