% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.varstan}
\alias{autoplot.varstan}
\title{autoplot methods for varstan models.}
\usage{
\method{autoplot}{varstan}(object, prob = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{varstan}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\code{90\%} intervals (\code{prob=0.9}) rather than the traditionally used
\code{95\%}.}

\item{...}{Further arguments passed to  \code{mcmc_combo}.}
}
\value{
None. Function produces a ggplot2 graph.
}
\description{
Preliminary autoplot methods for varstan models only valid for univariate time series models.
The function prints the fitted values time series, the trace and density plots for the
sampled model parameters, or the residuals' posterior mean time series.
}
\examples{
\donttest{
 sf1 = auto.sarima(ts = birth,iter = 500,chains = 1)
 # fitted model
 autoplot(sf1)
}

}
