% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{weights_cpp}
\alias{weights_cpp}
\alias{weights_cpp,OneStageBasket-method}
\alias{weights_cpp,TwoStageBasket-method}
\title{Weights Based on the Calibrated Power Prior}
\usage{
weights_cpp(design, ...)

\S4method{weights_cpp}{OneStageBasket}(
  design,
  n,
  a = 1,
  b = 1,
  prune = FALSE,
  lambda,
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)

\S4method{weights_cpp}{TwoStageBasket}(design, n, n1, a = 1, b = 1, ...)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{a}{first tuning parameter}

\item{b}{second tuning parameter}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.
If this is \code{TRUE} then \code{lambda} is also required and
if \code{globalweight_fun} is not \code{NULL} then
\code{globalweight_fun} and \code{globalweight_params} are also used.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}
}
\value{
A matrix including the weights of all possible pairwise outcomes.
}
\description{
Weights Based on the Calibrated Power Prior
}
\details{
\code{weights_cpp} calculates the weights based on an approach
by Pan & Yuan (2017). The weight for two baskets i and j is found by at
first calculating \eqn{S_{KS;i,j}} as the Kolmogorov-Smirnov statistic,
which is equal to the difference in response rates for binary variables.
\eqn{S_{KS;i,j}} is then transformed to \eqn{S_{i,j} = n^{1/4}S_{KS;i,j}}.
Then the weight is found as \eqn{1 / (1 + exp(a + b * log(S_{i,j})))}, where
a and b are tuning parameters.

The function is generally not called by the user but passed to another
function such as \code{\link{toer}} and \code{\link{pow}} to specificy
how the weights are calculated.
}
\section{Methods (by class)}{
\itemize{
\item \code{weights_cpp(OneStageBasket)}: Calibrated power prior weights for a single-stage
basket design.

\item \code{weights_cpp(TwoStageBasket)}: Calibrated power prior weights for a two-stage
basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
toer(design, n = 15, lambda = 0.99, weight_fun = weights_cpp)
}
\references{
Baumann, L., Sauer, L., & Kieser, M. (2024). A basket trial design based on
power priors. arXiv:2309.06988.

Pan, H., Yuan, Y., & Xia, J. (2017). A calibrated power prior
approach to borrow information from historical data with application to
biosimilar clinical trials. Journal of the Royal Statistical Society Series
C: Applied Statistics, 66(5), 979-996.
}
