% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_package_data_preprocessing.R
\name{dummify_data}
\alias{dummify_data}
\title{Dummify Design Matrix}
\usage{
dummify_data(data)
}
\arguments{
\item{data}{Data frame to be dummified.}
}
\value{
Returns a data frame with factors converted to dummy indicator variables.
}
\description{
Create a data frame with factors converted to dummies.
}
\details{
The column names of the dummy variables are given by the ``FactorName_LevelName'' and are augmented to the end of the design matrix. See the example below.
}
\note{
BART handles dummification internally. This function is provided as a utility function.
}
\examples{
\dontrun{
#generate data
set.seed(11)
x1 = rnorm(20)
x2 = as.factor(ifelse(x1 > 0, "A", "B"))
x3 = runif(20)
X = data.frame(x1,x2,x3)
#dummify data
X_dummified = dummify_data(X)
print(X_dummified)
}
}
\author{
Adam Kapelner and Justin Bleich
}
