% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_BASE.R
\name{BASE}
\alias{BASE}
\alias{base_}
\title{BASE class environment}
\usage{
base_(..., env = new.env(parent = parent.frame()), init_call = sys.call())
}
\arguments{
\item{...}{Ignored.}

\item{env}{Environment. The instance environment.}

\item{init_call}{Call. Contents of the \code{..init_call...} It is recommended to leave it
as default.}
}
\value{
An instance environment.
}
\description{
This class provides essential attributes and methods. It makes
the assumption that the container name is \code{..method_env..} and the name of
the reference to self is \code{self}. If you would like to use other container
names and self names, you need to overwrite the class definition of BASE.
\cr
\cr
The class environment is defined as an empty environment by \code{\link[=new.env]{new.env()}}
at build-time, and the class descriptor is run at load-time by
\code{\link[=.onLoad]{.onLoad()}}.
This ensures methods and attributes of the class is built with the
load-time (usually latest) installed dependencies (if it depends on any).
Derived classes should follow the same principle to avoid running the class
descriptor at build-time, and only defines the content of the class at
load-time.
\cr
\cr
Since \code{bandicoot} does not support dynamic dispatch,
calling the correct parent method can be difficult in a
complex class system.
So, users can use the \code{..mro..} (method resolution order) attribute and the
\code{\link[=super]{super()}} function to determine the correct super/next class.
If users decide to store parent environments in
the derived class such that parent method can be called more handily,
awareness needs to be raised when saving and loading these classes/instances.
It is very likely the same class stored in different objects becomes different
environments.
}
\section{Functions}{
\itemize{
\item \code{base_()}: Class constructor, same as \code{\link[=BASE$instantiate]{BASE$instantiate()}}.

}}
\section{Class information}{
\subsection{Attributes}{
\itemize{
\item B:
\itemize{
\item \link{BASE$..bases..}
}
\item C:
\itemize{
\item \link{BASE$..class..}
\item \link{BASE$..class_tree..}
}
\item I:
\itemize{
\item \link{BASE$..instantiated..}
}
\item M:
\itemize{
\item \link{BASE$..method_env..}
\item \link{BASE$..mro..}
}
}
}

\subsection{Methods}{
\itemize{
\item D:
\itemize{
\item \code{\link[=BASE$del_attr]{BASE$del_attr()}}
\item \code{\link[=BASE$..dir..]{BASE$..dir..()}}
}
\item G:
\itemize{
\item \code{\link[=BASE$get_attr]{BASE$get_attr()}}
}
\item H:
\itemize{
\item \code{\link[=BASE$has_attr]{BASE$has_attr()}}
}
\item I:
\itemize{
\item \code{\link[=BASE$..init..]{BASE$..init..()}}
\item \code{\link[=BASE$instantiate]{BASE$instantiate()}}
}
\item L:
\itemize{
\item \code{\link[=BASE$..len..]{BASE$..len..()}}
}
\item M:
\itemize{
\item \code{\link[=BASE$..methods..]{BASE$..methods..()}}
}
\item N:
\itemize{
\item \code{\link[=BASE$..new..]{BASE$..new..()}}
}
\item R:
\itemize{
\item \code{\link[=BASE$..repr..]{BASE$..repr..()}}
}
\item S:
\itemize{
\item \code{\link[=BASE$set_attr]{BASE$set_attr()}}
\item \code{\link[=BASE$..str..]{BASE$..str..()}}
}
}
}
}

