% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_auto_mount.R
\name{run_auto_mount}
\alias{run_auto_mount}
\title{Run a containerised command with automatic mounting of files}
\usage{
run_auto_mount(
  container_id,
  command,
  args = NULL,
  wd = NULL,
  wd_in_container = NULL,
  environment_variables = NULL,
  debug = FALSE,
  verbose = FALSE,
  stdout = "|",
  stderr = "|"
)
}
\arguments{
\item{container_id}{The name of the container, usually the repository name on dockerhub.}

\item{command}{Character scalar, the command to run. If you are
running \code{.bat} or \code{.cmd} files on Windows, make sure you read the
'Batch files' section in the \link[processx]{process} manual page.}

\item{args}{Character vector, arguments to the command. Any files or
directories that should be mounted must be named "file" (see example).}

\item{wd}{Local working directory to run command. If specified, the working
directory will be mounted to the docker container.}

\item{wd_in_container}{Working directory to run command in
the container. Defaults to the working directory mounted to the container
(\code{wd}).}

\item{environment_variables}{A character vector of environment variables. Format: \code{c("ENVVAR=VALUE")}.}

\item{debug}{If \code{TRUE}, a command will be printed that the user can execute to enter the container.}

\item{verbose}{Whether or not to print output}

\item{stdout}{What to do with standard output of the command. Default (\code{"|"}) means to include it as an item in the results list.
If it is the empty string (\code{""}), then the child process inherits the standard output stream of the R process.
If it is a string other than \code{"|"} and \code{""}, then it is taken as a file name and the output is redirected to this file.}

\item{stderr}{What to do with standard error of the command. Default ("|") means to include it as an item in the results list.
If it is the empty string (\code{""}), then the child process inherits the standard error stream of the R process.
If it is a string other than \code{"|"} and \code{""}, then it is taken as a file name and the standard error is redirected to this file.}
}
\value{
List, formatted as output from \code{\link[processx:run]{processx::run()}}
}
\description{
Similar to \code{\link[=run]{run()}}, but automatically mounts files (and directories) so the
user doesn't have to keep track of volumes.
}
\details{
The main difference to \code{\link[=run]{run()}} is that the use of names for the \code{args}; any
file (or directory) that should be mounted inside the container must be named
\code{file}. The other elements (arguments) don't need to be named. Note that it
is fine to have multiple elements with the same name (\code{file}).

This should generally work as long as the command accepts absolute paths
for file input. If that is not the case, use \code{\link[=run]{run()}} instead and specify
paths and mounting manually.
}
\examples{
if (test_docker_installation()) {

# Count the number of lines in the DESCRIPTION and LICENSE
# files of this package
run_auto_mount(
  container_id = "alpine",
  command = "wc",
  args = c("-l",
    file = system.file("DESCRIPTION", package = "babelwhale"),
    file = system.file("LICENSE", package = "babelwhale")
  )
)

}
}
