% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webservice.R
\name{get_webservice_token}
\alias{get_webservice_token}
\title{Retrieve the auth token for a web service}
\usage{
get_webservice_token(webservice)
}
\arguments{
\item{webservice}{The \code{AksWebservice} object.}
}
\value{
An \code{AksServiceAccessToken} object.
}
\description{
Get the authentication token, scoped to the current user,
for a web service that was deployed with token-based authentication
enabled. Token-based authentication requires clients to use an Azure
Active Directory account to request an authentication token, which is
used to make requests to the deployed service. Only available for
AKS deployments.

In order to enable token-based authentication, set the
\code{token_auth_enabled = TRUE} parameter when you are creating or
updating a deployment (\code{aks_webservice_deployment_config()} for creation
or \code{update_aks_webservice()} for updating). Note that you cannot have both
key-based authentication and token-based authentication enabled.
Token-based authentication is not enabled by default.

To check if a web service has token-based auth enabled, you can
access the following boolean property from the Webservice object:
\code{service$token_auth_enabled}
}
