% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_level.R
\name{.layout_json_custom}
\alias{.layout_json_custom}
\title{Customized logging layout}
\usage{
.layout_json_custom(
  log_fields = c("time", "level", "ns", "ans", "topenv", "fn", "node", "arch", "os_name",
    "os_release", "os_version", "pid", "user", "msg"),
  additional_fields = NULL,
  enforce_ascii_msg = TRUE,
  enforce_tz_utc = TRUE
)
}
\arguments{
\item{log_fields}{Vector of components which are collected in
\code{\link[logger]{get_logger_meta_variables}} function. Converting
\code{time} component to UTC additionally.}

\item{additional_fields}{A named vector of type list with key-value pairs of
additional meta data which needs to be added in logging context on top of
\code{log_fields}. The respective value of each key is expected to be of
length 1. It is \code{NULL} by default.}

\item{enforce_ascii_msg}{If \code{TRUE} (default), the logging message is
guaranteed to have all non-ASCII characters escaped. If \code{FALSE}, the
characters will be logged as-is. Please note, it is better to ensure
ASCII, otherwise there might be error while sending the HTTP POST request
to 'Azure Log Analytics' workspace.}

\item{enforce_tz_utc}{If \code{TRUE} (default), the logging time field is
converted to UTC timezone while sending the logging dump to 'Azure Log
Analytics' workspace. If \code{FALSE}, then the local time captured by
\code{\link[base]{Sys.time}} is recorded in the time field.}
}
\value{
Returns a generator function typically to be used by
\code{\link[logger]{log_layout}} function.
}
\description{
This is an extended function of \code{\link[logger]{layout_json}} function
from \code{'logger'} package. Objective is to add additional component in the
logging layout in JSON format so that they can also be reported while
logging along with the components collected by
\code{\link{.add_meta_variables}}.
}
