% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{pollyHTTP}
\alias{pollyHTTP}
\title{Execute AWS Polly API Request}
\usage{
pollyHTTP(
  action,
  query = list(),
  headers = list(),
  body = NULL,
  verb = c("GET", "POST", "PUT", "DELETE"),
  version = "v1",
  raw_response = if (verb == "POST") TRUE else FALSE,
  verbose = getOption("verbose", FALSE),
  region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"),
  key = NULL,
  secret = NULL,
  session_token = NULL,
  ...
)
}
\arguments{
\item{action}{A character string specifying the API action to take}

\item{query}{An optional named list containing query string parameters and their character values.}

\item{headers}{A list of headers to pass to the HTTP request.}

\item{body}{A request body}

\item{verb}{A character string specifying the HTTP verb to implement.}

\item{version}{A character string specifying the API version.}

\item{raw_response}{A logical indicating whether to return the raw response body.}

\item{verbose}{A logical indicating whether to be verbose. Default is given by \code{options("verbose")}.}

\item{region}{A character string specifying an AWS region. See \code{\link[aws.signature]{locate_credentials}}.}

\item{key}{A character string specifying an AWS Access Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{secret}{A character string specifying an AWS Secret Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{session_token}{Optionally, a character string specifying an AWS temporary Session Token to use in signing a request. See \code{\link[aws.signature]{locate_credentials}}.}

\item{\dots}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the Polly API.
}
\details{
This function constructs and signs an Polly API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}
