% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_traffic_mirror_session}
\alias{ec2_create_traffic_mirror_session}
\title{Create Traffic Mirror Session}
\usage{
ec2_create_traffic_mirror_session(
  NetworkInterfaceId,
  TrafficMirrorTargetId,
  TrafficMirrorFilterId,
  SessionNumber,
  PacketLength = NULL,
  VirtualNetworkId = NULL,
  Description = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{NetworkInterfaceId}{Character. The ID of the source network interface.}

\item{TrafficMirrorTargetId}{Character. The ID of the Traffic Mirror target.}

\item{TrafficMirrorFilterId}{Character. The ID of the Traffic Mirror filter.}

\item{SessionNumber}{Integer.   The session number determines the order in which sessions are evaluated when an interface is used...}

\item{PacketLength}{Integer.   The number of bytes in each packet to mirror.[optional]}

\item{VirtualNetworkId}{Integer. The VXLAN ID for the Traffic Mirror session.[optional]}

\item{Description}{Character. The description of the Traffic Mirror session.[optional]}

\item{TagSpecification}{List. The tags to assign to a Traffic Mirror session.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Traffic Mirror Session
}
\section{NetworkInterfaceId}{

The
ID of the source network interface.
}

\section{TrafficMirrorTargetId}{

The ID of the
Traffic Mirror target.
}

\section{TrafficMirrorFilterId}{

The ID of the Traffic Mirror
filter.
}

\section{SessionNumber}{


The session number determines the order in which sessions are evaluated
when an interface is used by multiple sessions. The first session with a
matching filter is the one that mirrors the packets.

Valid values are 1-32766.
}

\section{PacketLength}{


The number of bytes in each packet to mirror. These are bytes after the
VXLAN header. Do not specify this parameter when you want to mirror the
entire packet. To mirror a subset of the packet, set this to the length
(in bytes) that you want to mirror. For example, if you set this value
to 100, then the first 100 bytes that meet the filter criteria are
copied to the target.

If you do not want to mirror the entire packet, use the \code{PacketLength}
parameter to specify the number of bytes in each packet to mirror.
}

\section{VirtualNetworkId}{

The VXLAN ID for the Traffic Mirror session. For
more information about the VXLAN protocol, see \href{https://tools.ietf.org/html/rfc7348}{RFC 7348}. If you do not specify a
\code{VirtualNetworkId}, an account-wide unique id is chosen at
random.
}

\section{Description}{

The description of the Traffic Mirror
session.
}

\section{TagSpecification}{

The tags to assign to a Traffic Mirror
session.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

