% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-county.R
\name{auk_county}
\alias{auk_county}
\title{Filter the eBird data by county}
\usage{
auk_county(x, county, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{county}{character; counties to filter by. eBird uses county codes
consisting of three parts, the 2-letter ISO country code, a 1-3 character
state code, and a county code, all separated by a dash. For example,
\code{"US-NY-109"} corresponds to Tompkins, NY, US. The easiest way to find a
county code is to find the corresponding \href{https://ebird.org/explore}{explore region} page and look at the URL.}

\item{replace}{logical; multiple calls to \code{auk_county()} are additive,
unless \code{replace = FALSE}, in which case the previous list of states to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
counties This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\details{
It is not possible to filter by both county as well as country or
state, so calling \code{auk_county()} will reset these filters to all countries
and states, and vice versa.

This function can also work with on an \code{auk_sampling} object if the user only
wishes to filter the sampling event data.
}
\examples{
# choose tompkins county, ny, united states
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  auk_county("US-NY-109")
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_county(ebd, "US-NY-109")
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_exotic}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
