% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_freiburg.R
\name{boltzmann}
\alias{boltzmann}
\title{Boltzmann's function}
\usage{
boltzmann(L, L_50 = 18.4, s_50 = 0.08)
}
\arguments{
\item{L}{sound pressure level for which the intelligibility is to be computed}

\item{L_50}{sound pressure level at 50\% intelligibility}

\item{s_50}{intelligibility at L_50, happens to be 8\% in Freiburger Zahlentest
and 5\% in Freiburger Einsilbertest (values taken from S. Hoth, Der Freiburger
Sprachtest, HNO 2016, 64:540-48).}
}
\value{
predicted intelligibility
}
\description{
s-shaped curve , originally used as discrimination function to draw
the "normal" curves in the Freiburger Sprachtest before I could find
the official norm values. Could still be usefull for someone seeking
to add something like that to her plots be it as example or for simulation.
The function is given as
y = (exp(-4*(L-L_50))\*s_50)^-1
this is similar to a logistic regression result but with parameterization
that is expecially usefull here:
}
\examples{
# Freiburger Einsilbertest has L_50 = 29.3 dB and s_50 at 5 \%/dB.
# Compute the expected intelligibility at 20, 30 and 40 dB SPL

boltzmann(L = c(20, 30, 40), L_50 = 29.3, s_50 = .05)
}
