% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{list_chats}
\alias{list_chats}
\alias{get_user_chat}
\alias{check_user_chat_available}
\alias{send_chat_message}
\title{Interact with Bluesky Direct Messages}
\usage{
list_chats(
  limit = NULL,
  cursor = NULL,
  unread = FALSE,
  status = NULL,
  parse = TRUE,
  .token = NULL
)

get_user_chat(actor, parse = TRUE, .token = NULL)

check_user_chat_available(actor, parse = TRUE, .token = NULL)

send_chat_message(chat_id, text, .token = NULL)
}
\arguments{
\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{cursor}{Cursor for pagination (to pick up an old search).}

\item{unread}{\code{TRUE}/\code{FALSE} only show chats with unread messages.}

\item{status}{\code{request} or \code{accepted}.}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}

\item{actor}{user DID or handle to get chats for.}

\item{chat_id}{id of the chat. You can get it with \code{list_chats},
\code{get_user_chat}, or \code{check_user_chat_available}.}

\item{text}{text to send to other user.}
}
\value{
different objects.
}
\description{
Interact with Bluesky Direct Messages
}
\examples{
\dontrun{
list_chats(readState = "read")
}
}
