% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope_residual}
\alias{envelope_residual}
\alias{envelope_residual.default}
\alias{envelope_residual.glm}
\alias{envelope_residual.lm}
\title{Recommended Residuals for Envelope Plots}
\usage{
envelope_residual(object, ...)

\method{envelope_residual}{default}(object, ...)

\method{envelope_residual}{glm}(object, ...)

\method{envelope_residual}{lm}(object, ...)
}
\arguments{
\item{object}{An object for which model residuals can be extracted.}

\item{...}{Additional arguments passed to the residual function.}
}
\value{
A function that computes residuals from an object
}
\description{
This function returns a function that computes residuals for envelope plots.
These residuals are typically absolute values to be compared against the half-normal distribution.
}
\details{
For objects of class \code{glm}, the default residuals are:
\itemize{
\item Deviance residuals, except for \code{poisson} and \code{binomial} families.
\item For \code{poisson} and \code{binomial} families, the residuals are \code{\link[=rstudent]{rstudent()}}, for the case deletion residual.
}

For objects of class \code{lm}, the default residuals are also \code{\link[=rstudent]{rstudent()}}.

For other classes, the default is \code{\link[stats:residuals]{stats::residuals()}}, meaning no specialized recommendation is currently provided.
}
