#' MLB Players' Home Run and Batted Ball Statistics with Red Zone Metrics (2017-2019)
#'
#' This dataset provides annual statistics for Major League Baseball (MLB) players, including home run counts, at-bats, mean exit velocities, launch angles, quantile statistics of exit velocities and launch angles, and red zone metrics. It is intended for analyzing batted ball performance, with additional variables on the red zone, which is defined as balls in play with a launch angle between 20 and 35 degrees and an exit velocity of at least 95 mph.
#'
#' @format A data frame with the following columns:
#' \describe{
#'   \item{name}{Player's full name (character).}
#'   \item{playerID}{Player's unique identifier in the Lahman database (character).}
#'   \item{teamID}{Team abbreviation (character).}
#'   \item{year}{Season year (numeric).}
#'   \item{HR}{Home runs hit during the season (integer).}
#'   \item{AB}{At-bats during the season (integer).}
#'   \item{mean_exit_velo}{Average exit velocity (mph) over the season (numeric).}
#'   \item{mean_launch_angle}{Average launch angle (degrees) over the season (numeric).}
#'   \item{launch_angle_75}{Launch angle at the 75th percentile of the player's distribution (numeric).}
#'   \item{launch_angle_70}{Launch angle at the 70th percentile of the player's distribution (numeric).}
#'   \item{launch_angle_65}{Launch angle at the 65th percentile of the player's distribution (numeric).}
#'   \item{exit_velo_75}{Exit velocity at the 75th percentile of the player's distribution (numeric).}
#'   \item{exit_velo_80}{Exit velocity at the 80th percentile of the player's distribution (numeric).}
#'   \item{exit_velo_85}{Exit velocity at the 85th percentile of the player's distribution (numeric).}
#'   \item{count_red_zone}{Seasonal count of batted balls in the red zone, defined as a launch angle between 20 and 35 degrees and an exit velocity greater than or equal to 95 mph (integer).}
#'   \item{prop_red_zone}{Proportion of batted balls that fall into the red zone (numeric).}
#'   \item{BPF}{Ballpark factor, indicating the effect of the player's home ballpark on offensive statistics (integer).}
#' }
#'
#' @details
#' \describe{
#'   \item{Mean Metrics}{\code{mean_exit_velo} and \code{mean_launch_angle} represent the player's average exit velocities and launch angles, respectively, over the course of a season.}
#'   \item{Quantile Metrics}{The \code{launch_angle_xx} and \code{exit_velo_xx} columns denote the upper \eqn{x}-percentiles (e.g., 75th percentile) of the player's launch angle and exit velocity distributions for that year.}
#'   \item{Red Zone Metrics}{\code{count_red_zone} gives the number of balls in play that fall into the red zone, while \code{prop_red_zone} represents the proportion of balls in play in this category.}
#'   \item{BPF}{The Ballpark Factor (BPF) quantifies the influence of the player's home ballpark on offensive performance, with values above 100 indicating a hitter-friendly environment.}
#' }
#'
#' @source
#' - Player statistics: [Lahman R Package](https://CRAN.R-project.org/package=Lahman)
#' - Batted ball data: [Baseball Savant](https://baseballsavant.mlb.com/)
#' - Additional analysis: [Patterns of Home Run Hitting in the Statcast Era](https://bayesball.github.io/BLOG/homeruns.html) by Jim Albert
#'
#' @examples
#' data(bballHR)
#' head(bballHR)
#'
"bballHR"
