% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_connection}
\alias{assert_connection}
\title{Assert input is a database connection}
\usage{
assert_connection(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object to assert is a database connection}

\item{msg}{A custom error message displayed if \code{x} is not a valid database connection.}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
\code{invisible(TRUE)} if \code{x} is a valid database connection, otherwise aborts with an error message.
}
\description{
Assert the input object is a database connection, specifically of the "DBIConnection" class,
which is the standard virtual class used by the DBI package for database connections.
Note this assertion does not test if the database connection is valid and/or active.
}
\details{
This function is designed for use with objects inheriting from the "DBIConnection" class, which is used widely across database connection implementations in R.
As other database interface packages are introduced, additional checks may be added to support other connection classes.
}
\examples{
try({
  # Assuming a valid DBI connection `conn`:
  assert_connection(conn) # Passes if `conn` is a DBI connection

  assert_connection(42) # Fails with error message
})

}
\concept{assert_type}
