% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_items}
\alias{search_items}
\title{Search for Portal Items}
\usage{
search_items(
  query = NULL,
  filter = NULL,
  title = NULL,
  description = NULL,
  snippet = NULL,
  tags = NULL,
  owner = NULL,
  orgid = NULL,
  item_type = NULL,
  type_keywords = NULL,
  created = NULL,
  modified = NULL,
  categories = NULL,
  category_filters = NULL,
  sort_field = NULL,
  sort_order = NULL,
  count_fields = NULL,
  count_size = NULL,
  display_sublayers = FALSE,
  filter_logic = "and",
  bbox = NULL,
  page_size = 50,
  max_pages = Inf,
  .progress = TRUE,
  host = arc_host(),
  token = arc_token()
)
}
\arguments{
\item{query}{a scalar character for free text search or a valid query string as defined by the REST API.}

\item{filter}{a scalar character. If provided all other arguments except query are ignored.}

\item{title}{optional character vector of content item titles.}

\item{description, snippet}{optional scalar character of text to check for.}

\item{tags}{optional character vector of tags to search for.}

\item{owner}{optional character vector of owner usernames to search for.}

\item{orgid}{optional character vector of organization IDs to search for.}

\item{item_type}{optional character vector of content item types. Validated with \code{\link[=item_type]{item_type()}}.}

\item{type_keywords}{optional character vector of content tpye keywords. Validated with \code{\link[=item_keyword]{item_keyword()}}.}

\item{created, modified}{optional length two vector which must be coercible to a date time vector. Converted using \code{\link[=as.POSIXct]{as.POSIXct()}}. Returns only items within this range.}

\item{categories}{optional character vector of up to 8 organization content categories.}

\item{category_filters}{optional character vector of up to 3 category terms. Items that have matching categories are returned. Exclusive with \code{categories}.}

\item{sort_field}{optional character vector of fields to sort by. Can sort by \code{title}, \code{created}, \code{type}, \code{owner}, \code{modified}, \code{avgrating}, \code{numratings}, \code{numcomments}, \code{numviews}, and \code{scorecompleteness}.}

\item{sort_order}{optional string. One of either \code{asc} or \code{desc} for ascending or descending order respectively.}

\item{count_fields}{optional character vector of up to 3 fields to count. Must be one of \code{c("type", "access", "contentstatus", "categories")}.}

\item{count_size}{optional integer determines the maximum number of field values to count for each counted field in \code{count_fields}. Maximum of 200.}

\item{display_sublayers}{default \code{FALSE}. Returns feature layers inside of feature services.}

\item{filter_logic}{default \code{"and"} must be one of \code{c("and", "or", "not")}. Determines if parameters}

\item{bbox}{unimplemented.}

\item{page_size}{a scalar integer between 1 and 100 indicating the number of responses per page.}

\item{max_pages}{the maximum number of pages to fetch. By default fetches all pages.}

\item{.progress}{default \code{TRUE}. Whether to display a progress bar for requests.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[=auth_code]{auth_code()}}
or related function}
}
\value{
a data.frame.
}
\description{
Perform full text search or use parameters to programamatically query your portal for content items.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Search is quite nuanced and should be handled with care as you may get unexpected results.
\itemize{
\item Most arguments are passed as \code{filter} parameters to the API endpoint.
\item If multiple values are passed to an argument such as \code{tags}, the search will use an \code{"OR"} statement.
\item When multiple arguments are provided, for example \code{tags}, \code{owner}, and \code{item_type}, the search will use \code{"AND"} logic—i.e. results shown match the \code{tags} \strong{and} \code{owner} \strong{and} \code{item_type}.
\itemize{
\item Note: you can change this to \code{"OR"} behavior by setting \code{filter_logic = "or"}
}
\item If the \code{filter} argument is provided, all other arguments except \code{query} are ignored.
}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
crime_items <- search_items(
  query = "crime",
  item_type = "Feature Service",
  max_pages = 1
)
crime_items
\dontshow{\}) # examplesIf}
}
\references{
\href{https://developers.arcgis.com/rest/users-groups-and-items/search}{API Documentation}
}
