% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esri-field-mapping.R
\name{as_fields}
\alias{as_fields}
\alias{infer_esri_type}
\alias{fields_as_ptype_df}
\alias{ptype_tbl}
\title{Esri Field Type Mapping}
\usage{
as_fields(.data, arg = rlang::caller_arg(.data), call = rlang::caller_env())

infer_esri_type(
  .data,
  arg = rlang::caller_arg(.data),
  call = rlang::caller_env()
)

fields_as_ptype_df(fields, n = 0, call = rlang::caller_env())

ptype_tbl(fields, n = 0, call = rlang::caller_env())
}
\arguments{
\item{.data}{an object of class \code{data.frame}.}

\item{arg}{An argument name in the current function.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}

\item{fields}{a list or data.frame of field types. Requires the fields \code{type} and \code{name} to be present.}

\item{n}{the number of rows to create in the prototype table}
}
\value{
\itemize{
\item \code{fields_as_ptype_df()} takes a \code{data.frame} with columns \code{name} and \code{type} and creates an empty \code{data.frame} with the corresponding columns and R types
\item \code{as_fields()} returns a \code{data.frame} with columns \code{name}, \code{type}, \code{alias}, \code{nullable}, and \code{editable} columns
\itemize{
\item This resembles that of the \code{fields} returned by a FeatureService
}
}
}
\description{
Infers Esri field types from R objects. Use \code{\link[=as_fields]{as_fields()}} to create a
data.frame of valid \href{https://developers.arcgis.com/web-map-specification/objects/field/}{Esri Field Types}
from an \code{sf} object or \code{data.frame}.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{as_fields()} takes a data frame-like object and infers the Esri field type from it.
\item \code{fields_as_pytpe_df()} takes a list with \code{type} and \code{name} and creates an empty \code{data.frame} with the corresponding column names and types.
\item \code{get_ptype()} takes a scalar character containing the Esri field type and returns a prototype of the pertinent R type
}
\subsection{Field type mapping:}{

Esri field types are mapped as
\itemize{
\item \code{esriFieldTypeSmallInteger}: integer
\item \code{esriFieldTypeSingle}: double
\item \code{esriFieldTypeGUID}: integer
\item \code{esriFieldTypeOID}: integer
\item \code{esriFieldTypeInteger}: integer
\item \code{esriFieldTypeBigInteger}: double
\item \code{esriFieldTypeDouble}: double
\item \code{esriFieldTypeString}: character
\item \code{esriFieldTypeDate}: date
}

R types are mapped as
\itemize{
\item \code{double}: esriFieldTypeDouble
\item \code{integer}: esriFieldTypeInteger
\item \code{character}: esriFieldTypeString
\item \code{date}: esriFieldTypeDate
\item \code{raw}: esriFieldTypeBlob
}
}
}
\examples{
inferred <- as_fields(iris)
inferred

fields_as_ptype_df(inferred)

}
