% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-categories.R
\name{categories}
\alias{categories}
\title{Return the name and category ID of all categories, or categories which satisfy a filter}
\usage{
categories(
  search_text = NULL,
  icon = NULL,
  language = NULL,
  token = arc_token()
)
}
\arguments{
\item{search_text}{Default \code{NULL}. Free search text for places against names, categories etc. Must be a scalar value.}

\item{icon}{Default \code{NULL}. Must be one of \code{"svg"}, \code{"png"} \code{"cim"}. Determines whether icons are returned and the type of icon to use with a place or category.}

\item{language}{Optional case-sensitive parameter to specify the preferred language to.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{category_id}: the unique identifier for the category
\item \code{full_label}: a list of character vectors containing all labels for the category
\item \code{icon_url}: a character vector containing the icon URL if present
\item \code{parents}: a list of character vectors containing the parent \code{category_id} values
}
}
\description{
A category describes a type of place, such as "movie theater" or "zoo". The places service has over 1,000 categories (or types) of place. The categories fall into ten general groups: Arts and Entertainment, Business and Professional Services, Community and Government, Dining and Drinking, Events, Health and Medicine, Landmarks and Outdoors, Retail, Sports and Recreation, and Travel and Transportation.
}
\details{
The categories are organized into a hierarchical system where a general category contains many more detailed variations on the parent category. For example: "Travel and Transportation" (Level 1), "Transport Hub" (Level 2), "Airport" (Level 3) and "Airport Terminal" (Level 4). The hierarchy has up to 5 levels of categories.
}
\examples{
\dontrun{
categories("Coffee Shop")
}
}
\references{
\href{https://developers.arcgis.com/rest/places/categories-get/}{API Documentation}
}
