% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_uncertainty.R
\name{mu_confusion_matrix}
\alias{mu_confusion_matrix}
\title{Map unit confusion matrix and other classification measures}
\usage{
mu_confusion_matrix(
  x,
  mapunit = "nationalmusym",
  cophase = "coiid",
  comppct = "comppct_r",
  muacres = "muacres"
)
}
\arguments{
\item{x}{\code{data.frame}}

\item{mapunit}{\code{character} column name containing the mapunit identifier (e.g. nationalmusym)}

\item{cophase}{\code{character} column name containing the soil component phase identifier (e.g. coiid or paste(compname, localphase))}

\item{comppct}{\code{character} column name containing the component percent (e.g. comppct_r)}

\item{muacres}{\code{character} column name containing the total area of the mapunit (e.g. muacres)}
}
\value{
\code{list} a confusion matrix, overall purity (OP) (i.e. overall accuracy), map unit purity (MP) (i.e. user accuracy), class representation (CR) (i.e. producer accuracy), and Shannon entropy (E). The measure names were selected to be consistent with the alternative terms proposed by Lark (1995) and Brus (2011).
}
\description{
This function reverse engineers a confusion matrix and other classification measures from soil map unit component percentages (i.e. composition) and area (i.e. acres).
}
\details{
\code{mu_confusion_matrix} There are several common statistical measures used to gauge the accuracy of categorical maps. These measures are typically not estimated for soil surveys but can be inferred from a map unit’s soil component composition percentages and size (i.e. acres). In general, overall purity or accuracy (OP) is related to map unit kind (e.g. consociations vs complexes). For several reasons, the “true” accuracies are unknown, and these values should be interpreted as Bayesian prior estimates. However, it is likely that the estimates are optimistic if they haven't been derived from an external validation. Existing and future digital soil mapping products could be used to validate how optimistic the current OA estimates are.
}
\examples{

# example data
mu <- rbind(
    data.frame(mapunit = "A", cophase = c("Alpha", "Beta"), comppct = c(90, 10), muacres = 100),
    data.frame(mapunit = "B", cophase = c("Beta", "Alpha"), comppct = c(70, 30), muacres = 1000)
    )

mu_confusion_matrix(mu, mapunit = "mapunit", cophase = "cophase", comppct = "comppct")

}
\references{
\itemize{
\item Brus DJ, Kempen B, Heuvelink GBM. 2011. Sampling for validation of digital soil maps. European Journal of Soil Science. 62(3):394–407. \doi{10.1111/j.1365-2389.2011.01364.x}
\item Lark RM. 1995. Components of accuracy of maps with special reference to discriminant analysis on remote sensor data. International Journal of Remote Sensing. 16(8):1461–1480. \doi{10.1080/01431169508954488}
}
}
\seealso{
\code{\link[=tauW]{tauW()}}, \code{\link[=shannonEntropy]{shannonEntropy()}}, \code{\link[=confusionIndex]{confusionIndex()}}
}
\author{
Stephen Roecker
}
