% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx.R
\name{apsimx}
\alias{apsimx}
\title{Run an APSIM-X simulation}
\usage{
apsimx(
  file = "",
  src.dir = ".",
  silent = FALSE,
  intern = FALSE,
  value = "report",
  cleanup = FALSE,
  simplify = TRUE,
  xargs
)
}
\arguments{
\item{file}{file name to be run (the extension .apsimx is optional)}

\item{src.dir}{directory containing the .apsimx file to be run (defaults to the current directory)}

\item{silent}{whether to print messages from apsim simulation. This is passed to argument \sQuote{ignore.stdout} for
function \code{\link{system}}.}

\item{intern}{This is passed to argument \sQuote{intern} for function \code{\link{system}}.}

\item{value}{how much output to return: \cr
option \sQuote{report} returns only the \sQuote{main} report component; \cr
option \sQuote{all} returns all components of the simulation; \cr
option \sQuote{none} does not create a data.frame but it generates the databases; \cr
option \sQuote{user-defined} should be the name of a specific table}

\item{cleanup}{logical. Whether to delete the .db file generated by APSIM-X. Default is FALSE}

\item{simplify}{whether to return a single data frame when multiple reports are present. If FALSE it will return a list.}

\item{xargs}{extra arguments to be passed to the APSIM-X run. Use function xargs_apsimx.}
}
\value{
a data frame with the \sQuote{Report} from the APSIM-X simulation. The return value depends on the argument \sQuote{value} above.
}
\description{
Run apsimx from R. It uses \code{\link{system}} (unix) or \code{\link{shell}} (windows) and it attempts to be platform independent.
}
\details{
Run an APSIM-X Simulation

A valid apsimx file can be run from within R. The main goal is to make running APSIM-X
simple, especially for large scale simulations or parameter optimization
}
\examples{
\donttest{
## See function 'apsimx_example' and vignette 'apsimx'
}

}
