% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_find.R
\name{cov_find}
\alias{cov_find}
\title{Find covariates of particular types}
\usage{
cov_find(df, cov, type)
}
\arguments{
\item{df}{PK(PD) dataset}

\item{cov}{covariate distribution}

\item{type}{covariate type}
}
\value{
vector of desired column names
}
\description{
Can filter for categorical, continuous, or other covariates.
Can filter for numeric or character type.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)

## Simple dm domain for the corresponding study
dm <- data.frame(USUBJID = c("ABC101-001",
                             "ABC101-002",
                             "ABC101-003"),
                 AGE = c(45,
                         37,
                         73),
                 AGEU = "years",
                 SEX = c("Male",
                         "Female",
                         "Male"),
                 RACE = c("White",
                          "White",
                          "Black"),
                 ETHNIC = c("Not Hispanic/Latino",
                            "Not Hispanic/Latino",
                            "Not Hispanic/Latino"))

## Add covariates with cov_apply()
df1 <- cov_apply(df, dm)

## Find covariates with cov_find()
cov_find(df1, cov="categorical", type="numeric")
cov_find(df1, cov="categorical", type="character")
cov_find(df1, cov="continuous", type="numeric")
cov_find(df1, cov="units", type="character")

}
