% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dffits_test.R
\name{dffits_test}
\alias{dffits_test}
\title{Identify influential observations}
\usage{
dffits_test(model, n = stats::nobs(model))
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{The number of outliers to return. The default is
all influential observations.}
}
\value{
A vector of influential observations.
}
\description{
\code{dffits_test} returns the observations identified
as influential based on the absolute value of the DFFITS statistics being
larger than a threshold. \cr\cr The threshold used is \eqn{2\sqrt{p/n}},
where \eqn{p = }\code{length(stats::coef(model))} and
\eqn{n = }\code{stats::nobs(model)}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
dffits_test(lmod)
}
\seealso{
\code{\link[stats]{dffits}}
}
