% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{apa_cor}
\alias{apa_cor}
\title{APA-formatted correlation table}
\usage{
apa_cor(
  data,
  note = NULL,
  p_value = c(0.05, 0.01, 0.001),
  digits = 2,
  bold_significant = FALSE,
  star_significant = TRUE,
  significance_note = TRUE,
  output = c("flextable", "tibble"),
  font_family = NULL,
  font_size = 12,
  text_color = "black",
  border_color = "black",
  border_width = 0.5,
  line_spacing = 2,
  table_width = 6.5,
  keep_empty_star_columns = TRUE,
  summary_functions = list(M = mean, SD = stats::sd),
  column_formats = NULL,
  ...
)
}
\arguments{
\item{data}{data.frame or tibble with variables to be}

\item{note}{Custom note to appear below table. (Overrides automatic note.)}

\item{p_value}{p-value needed to be flagged as significant}

\item{digits}{Number of digits for rounding}

\item{bold_significant}{bold significant correlations}

\item{star_significant}{start significant correlations}

\item{significance_note}{If TRUE, place note at bottom of table that significant correlations are bolded.}

\item{output}{output type. Can be "flextable" or "tibble"}

\item{font_family}{font family}

\item{font_size}{font size}

\item{text_color}{text color}

\item{border_color}{border color}

\item{border_width}{border width in pixels}

\item{line_spacing}{spacing between lines}

\item{table_width}{table width (in pixels, 0 for auto)}

\item{keep_empty_star_columns}{Keep remove empty star columns (Default: \code{TRUE})}

\item{summary_functions}{A named list of functions that summarize data columns (e.g., mean, sd)}

\item{column_formats}{column_formats object}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> parameters passed to psych::corTest}
}
\value{
flextable::flextable
}
\description{
APA-formatted correlation table
}
\examples{
apa_cor(mtcars[, c("mpg", "am", "gear", "carb")], output = "flextable")
apa_cor(mtcars[, c("mpg", "am", "gear", "carb")], output = "tibble")
}
