% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.plots.R
\name{anim.hist}
\alias{anim.hist}
\title{Draw an animated histogram.}
\usage{
anim.hist(
  x,
  times,
  speed = 1,
  show = TRUE,
  use.times = TRUE,
  window = t,
  window.process = NULL,
  density = NULL,
  angle = NULL,
  col = NULL,
  border = NULL,
  ...
)
}
\arguments{
\item{x, density, angle, col, border, ...}{parameters passed to \code{\link{hist}}.}

\item{times, show, speed, use.times, window, window.process}{see 
\code{\link{anim.plot}}.}
}
\description{
Draw an animated histogram.
}
\details{
Parameters \code{x, density, angle, col} and \code{border} are all
"chunked", i.e. first recycled to the length of \code{times} or \code{x}
(whichever is longer), then split according to the unique values of \code{times}.
See \code{\link{anim.plot}} for more details.
}
\examples{
anim.hist(rep(rnorm(5000), 7), times=rep(1:7, each=5000), 
     breaks=c(5,10,20,50,100,200, 500, 1000))
}
