% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calculate_tree}
\alias{calculate_tree}
\title{Propagate Answers and Confidence Up the Tree}
\usage{
calculate_tree(tree)
}
\arguments{
\item{tree}{The \code{data.tree} object to be calculated. The function modifies
this object directly.}
}
\value{
The modified \code{tree} object (returned invisibly).
}
\description{
This function performs a full, bottom-up recalculation of the decision tree's
state. It takes the user-provided answers and confidences at the leaf level
and propagates the logical outcomes (\code{answer}) and aggregate confidence scores
up to the parent nodes based on their \code{AND}/\code{OR} rules.
}
\details{
This function is one of three called by \code{update_tree()}, which does a full
recalculation of the decision tree result and optimisation indices.

The function first resets the \code{answer} and \code{confidence} of all non-leaf nodes
to \code{NA} to ensure a clean calculation.

It then uses a \strong{post-order traversal}, which is critical as it guarantees
that a parent node is only processed after all of its children have been processed.

The logical rules are applied with short-circuiting:
\describe{
\item{\strong{OR Nodes:}}{Become \code{TRUE} if any child is \code{TRUE}. Become
\code{FALSE} only if all children are answered and none are \code{TRUE}.}
\item{\strong{AND Nodes:}}{Become \code{FALSE} if any child is \code{FALSE}.
Become \code{TRUE} only if all children are answered and none are \code{FALSE}.}
}

The confidence calculation is based on the confidences of the children that
determined the outcome (e.g., only the \code{TRUE} children for a resolved \code{OR} node).
}
\examples{
# Load the data
ethical_tree <- load_tree_df(ethical)

# Answer some questions
set_answer(ethical_tree, "FIN2", TRUE, 4)
set_answer(ethical_tree, "ENV2", TRUE, 3)
set_answer(ethical_tree, "SOC2", TRUE, 4)
set_answer(ethical_tree, "GOV2", FALSE, 1)

# Calculate the tree
ethical_tree <- calculate_tree(ethical_tree)

# View the result
print_tree(ethical_tree)

}
