% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_ensemble.R
\docType{methods}
\name{c14_ensemble}
\alias{c14_ensemble}
\alias{c14_ensemble-method}
\alias{c14_ensemble,CalibratedAges-method}
\title{Radiocarbon Event Count}
\usage{
c14_ensemble(object, ...)

\S4method{c14_ensemble}{CalibratedAges}(
  object,
  from = NULL,
  to = NULL,
  by = 10,
  n = 100,
  calendar = BP(),
  progress = getOption("ananke.progress")
)
}
\arguments{
\item{object}{A \code{\linkS4class{CalibratedAges}} object.}

\item{...}{Currently not used.}

\item{from}{length-one \code{\link{numeric}} vector specifying the earliest data to
calibrate for (in cal BP years).}

\item{to}{A length-one \code{\link{numeric}} vector specifying the latest data to
calibrate for (in cal BP years).}

\item{by}{A length-one \code{\link{numeric}} vector specifying the temporal
resolution (in years) of the calibration.}

\item{n}{An \code{\link{integer}} specifying the number of item to choose randomly.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). Defaults to \code{\link[aion:gregorian]{aion::CE()}}. If \code{NULL},
\emph{rata die} are returned.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}
}
\value{
An \code{\linkS4class{RECE}} object.
}
\description{
Radiocarbon Event Count
}
\note{
This function is currently \emph{experimental}.
}
\references{
Carleton, W. C. (2021). Evaluating Bayesian Radiocarbon‐dated Event Count
(REC) Models for the Study of Long‐term Human and Environmental Processes.
\emph{Journal of Quaternary Science}, 36(1): 110‑23. \doi{10.1002/jqs.3256}.
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
