% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kurtosis}
\alias{kurtosis}
\title{Kurtosis}
\usage{
kurtosis(x, na.rm = T)
}
\arguments{
\item{x}{a numeric vector, matrix or a data.frame}

\item{na.rm}{(logical) Should missing values be removed?}
}
\value{
returns a single value if \code{x} is a vector, otherwise a named
  vector of size \code{= ncol(x)}.
}
\description{
\code{kurtosis} calculates the Kurtosis
}
\details{
This function calculates the kurtosis of data which is a measure of the
"tailedness" of the probability distribution of a real-valued random
variable. Like skewness, kurtosis describes the shape of a probability
distribution. The formula used is: \deqn{\frac{E[(X-\mu)^{4}]}{(
E[(X-\mu)^2])^{2}}}.
This formula is the typical definition
used in many older textbooks and wikipedia
}
\examples{
# for a single vector
kurtosis(mtcars$mpg)

# for a dataframe
kurtosis(mtcars)

}
