% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlFunctions-trawl.R
\name{trawl_supIG}
\alias{trawl_supIG}
\title{Evaluates the supIG trawl function}
\usage{
trawl_supIG(x, delta, gamma)
}
\arguments{
\item{x}{the argument at which the supIG trawl function will be evaluated}

\item{delta}{the parameter \eqn{\delta} in the supIG trawl}

\item{gamma}{the parameter \eqn{\gamma} in the supIG trawl}
}
\value{
The supIG trawl function evaluated at x
}
\description{
Evaluates the supIG trawl function
}
\details{
The trawl function is parametrised by the two parameters \eqn{\delta
 \geq 0} and \eqn{\gamma \geq 0} as follows: \deqn{gd(x) =
 (1-2x\gamma^{-2})^{-1/2}\exp(\delta \gamma(1-(1-2x\gamma^{-2})^{1/2})),
 \mbox{ for } x \le 0.} It is assumed that \eqn{\delta} and \eqn{\gamma} are
 not simultaneously equal to zero.
}
\examples{
trawl_supIG(-1,0.5,0.2)
}
