% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AmbitSimulation.R
\name{sim_weighted_trawl}
\alias{sim_weighted_trawl}
\title{Simulation of a weighted trawl process}
\usage{
sim_weighted_trawl(
  n,
  Delta,
  trawlfct,
  trawlfct_par,
  distr,
  distr_par,
  kernelfct = NULL
)
}
\arguments{
\item{n}{number of grid points to be simulated (excluding the starting value)}

\item{Delta}{grid-width}

\item{trawlfct}{the trawl function a used in the simulation (Exp, supIG or LM)}

\item{trawlfct_par}{parameter vector of trawl function
(Exp: lambda, supIG: delta, gamma, LM: alpha, H)}

\item{distr}{marginal distribution. Choose from "Gamma" (Gamma),
"Gauss" (Gaussian), "Cauchy"
(Cauchy), "NIG" (Normal Inverse Gaussian),
Poi" (Poisson), "NegBin" (Negative Binomial)}

\item{distr_par}{parameters of the marginal distribution:
(Gamma: shape, scale;
Gauss: mu, sigma (i.e. the second parameter is the standard deviation, not the
variance);
Cauchy: l, s;
NIG: alpha, beta, delta, mu;
Poi: v, NegBin: m, theta)}

\item{kernelfct}{the kernel function p used in the ambit process}
}
\value{
path Simulated  path

slice_sizes slice sizes used

S_matrix Matrix of all slices

kernelweights kernel weights used
}
\description{
This function simulates a weighted trawl process for various
choices of the trawl function and the marginal distribution.
}
\details{
This functions simulates a sample path from a weighted trawl process
given by
\deqn{	Y_t =\int_{(-\infty,t]\times (-\infty, \infty)}
p(t-s)I_{(0,a(t-s))}(x)L(dx,ds),}
 for   \eqn{t \ge 0},
and returns \eqn{Y_0, Y_{\Delta}, \ldots, Y_{n\Delta}}.
}
\examples{
\donttest{
#Simulation of a Gaussian trawl process with exponential trawl function
n<-2000
Delta<-0.1
trawlfct="Exp"
trawlfct_par <-0.5
distr<-"Gauss"
distr_par<-c(0,1) #mean 0, std 1
set.seed(233)
path <- sim_weighted_trawl(n, Delta, trawlfct, trawlfct_par, distr, distr_par)$path
#Plot the path
library(ggplot2)
df <- data.frame(time = seq(0,n,1), value=path)
p <- ggplot(df, aes(x=time, y=path))+
  geom_line()+
  xlab("l")+
  ylab("Trawl process")
  p
}
}
