% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recur-on-easter.R
\name{recur_on_easter}
\alias{recur_on_easter}
\title{Recur on easter}
\usage{
recur_on_easter(x, offset = NULL)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{offset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\verb{[integer(1)]}

Deprecated in favor of using \code{\link[=roffset]{roffset()}} directly.

An offset in terms of a number of days on either side of Easter to recur
on. This offset must still fall within the same year, otherwise the date
will be silently ignored.}
}
\value{
An updated rrule.
}
\description{
\code{recur_on_easter()} is a special helper to recur on Easter. Easter is
particularly difficult to construct a recurrence rule for.
}
\examples{
on_easter <- yearly() \%>\% recur_on_easter()

# Rather than:
if (FALSE) {
on_easter_monday <- yearly() \%>\% recur_on_easter(1)
}

# Please use:
on_easter_monday <- roffset(on_easter, 1)

alma_search("1999-01-01", "2001-01-01", on_easter)

both <- runion(on_easter, on_easter_monday)

alma_search("1999-01-01", "2001-01-01", both)
}
