% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holidays.R
\name{holidays}
\alias{holidays}
\alias{hol_christmas}
\alias{hol_christmas_eve}
\alias{hol_easter}
\alias{hol_good_friday}
\alias{hol_halloween}
\alias{hol_new_years_day}
\alias{hol_new_years_eve}
\alias{hol_st_patricks_day}
\alias{hol_valentines_day}
\alias{hol_us_election_day}
\alias{hol_us_fathers_day}
\alias{hol_us_independence_day}
\alias{hol_us_indigenous_peoples_day}
\alias{hol_us_juneteenth}
\alias{hol_us_labor_day}
\alias{hol_us_martin_luther_king_junior_day}
\alias{hol_us_memorial_day}
\alias{hol_us_mothers_day}
\alias{hol_us_presidents_day}
\alias{hol_us_thanksgiving}
\alias{hol_us_veterans_day}
\title{Holidays}
\usage{
hol_christmas(since = NULL, until = NULL)

hol_christmas_eve(since = NULL, until = NULL)

hol_easter(since = NULL, until = NULL)

hol_good_friday(since = NULL, until = NULL)

hol_halloween(since = NULL, until = NULL)

hol_new_years_day(since = NULL, until = NULL)

hol_new_years_eve(since = NULL, until = NULL)

hol_st_patricks_day(since = NULL, until = NULL)

hol_valentines_day(since = NULL, until = NULL)

hol_us_election_day(since = NULL, until = NULL)

hol_us_fathers_day(since = NULL, until = NULL)

hol_us_independence_day(since = NULL, until = NULL)

hol_us_indigenous_peoples_day(since = NULL, until = NULL)

hol_us_juneteenth(since = NULL, until = NULL)

hol_us_labor_day(since = NULL, until = NULL)

hol_us_martin_luther_king_junior_day(since = NULL, until = NULL)

hol_us_memorial_day(since = NULL, until = NULL)

hol_us_mothers_day(since = NULL, until = NULL)

hol_us_presidents_day(since = NULL, until = NULL)

hol_us_thanksgiving(since = NULL, until = NULL)

hol_us_veterans_day(since = NULL, until = NULL)
}
\arguments{
\item{since}{\verb{[Date(1)]}

A lower bound on the event set to generate.

Defaults to \code{\link[=almanac_since]{almanac_since()}} if not set.}

\item{until}{\verb{[Date(1)]}

An upper bound on the event set to generate.

Defaults to \code{\link[=almanac_until]{almanac_until()}} if not set.}
}
\description{
This page lists a number of pre-created holidays that can be added to a
calendar created with \code{\link[=rcalendar]{rcalendar()}}. This list makes no attempt to be
comprehensive. If you need to create your own holiday, you can do so with
\code{\link[=rholiday]{rholiday()}}.

It also makes no attempt to be historically accurate, i.e. Juneteenth was
created in 2021, but \code{hol_us_juneteenth()} will generate event dates before
that. Because \code{\link[=rholiday]{rholiday()}} takes an arbitrary rschedule object, you can
always create an rschedule that is historically accurate and use that
instead.
}
\details{
Note that \emph{relative} holidays, such as New Year's Eve, which is 1 day before
New Year's Day, aren't pre-created in a way that allows you to define
observance rules for them that depend on the observance rules of the holiday
they are relative to. If you need to do this, you should start with the base
holiday, here \code{\link[=hol_new_years_day]{hol_new_years_day()}}, and use \code{\link[=hol_observe]{hol_observe()}} and
\code{\link[=hol_offset]{hol_offset()}} on that to generate a New Year's Eve holiday that matches
your required observance rules. See the examples of \code{\link[=hol_offset]{hol_offset()}} for more
information.
}
\examples{
on_christmas <- hol_christmas()
on_christmas

# These are like any other rschedule object
alma_events(on_christmas, year = 2020:2025)

# But they can also be added into an rcalendar
cal <- rcalendar(
  on_christmas,
  hol_halloween(),
  hol_new_years_day(),
  hol_us_presidents_day()
)
cal

# Which gives you access to a number of `cal_*()` functions
cal_events(cal, year = 2020:2022)
}
