% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment_file.R
\name{alignment_file}
\alias{alignment_file}
\title{Pre-bundled alignments}
\usage{
alignment_file(gene)
}
\arguments{
\item{gene}{The gene name of one of the pre-bundled alignments. Run
\code{\link[=alignment_file]{alignment_file()}} to list all genes available.}
}
\value{
Either a data frame of the pre-bundled alignments if parameter \code{gene}
is missing (default behaviour), or the file name of the alignment of a
supplied gene name.
}
\description{
This function returns either a data frame of the pre-bundled alignments if
parameter \code{gene} is missing (default behaviour), or the file name of the
alignment of a supplied gene name.
}
\examples{
# List pre-bundled alignment file names and associated genes
alignment_file()

# Retrieve the file name of an alignment
alignment_file("BRCA1")

# You may get the full path to an alignment file with `system.file()`
system.file("extdata", alignment_file("BRCA1"), package = "agvgd")

}
