% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventsNeeded2.R
\name{eventsNeeded2}
\alias{eventsNeeded2}
\title{Number events needed (fixed sample size)}
\usage{
eventsNeeded2(N, bta1, thta, alp = 0.05, pow = 0.8, ar = 0.5, Lmessage = FALSE)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total).}

\item{Lmessage}{If TRUE indicates how many estimates of L were negative before setting to Inf. Default FALSE.}
}
\value{
The number of events (L) needed to achieve target power at one-sided Type I control level alpha/2, given the input assumptions.
}
\description{
Function to compute number events (L) needed to achieve given power with fixed sample size N.
}
\details{
Assumes rate ratio < 1 is favourable to treatment.
A negative estimated number of events indicates no number of events is sufficient under the input assumptions.
}
\examples{

eventsNeeded2(N = 500, bta1 = log(0.8), thta = 2, alp = 0.05, pow = 0.8)
eventsNeeded2(N = 500, bta1 = log(0.8), thta = 3, alp = 0.05, pow = 0.8)

if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    RR = c(0.6, 0.7, 0.8),
    thta = c(2, 3, 4),
    pow = 0.8,
    N = c(500, 1000)
  ) \%>\%
    mutate(L = eventsNeeded2(N = N, bta1 = log(RR), thta = thta, alp, pow))

  assumptions \%>\% data.frame()

}

}
