% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agops-impact.R
\name{index_maxprod}
\alias{index_maxprod}
\title{Kosmulski's MAXPROD-index}
\usage{
index_maxprod(x)
}
\arguments{
\item{x}{a non-negative numeric vector}
}
\value{
a single numeric value
}
\description{
Given a sequence of \eqn{n} non-negative numbers \eqn{x=(x_1,\dots,x_n)},
where \eqn{x_i \ge x_j \ge 0} for \eqn{i \le j},
the \dfn{MAXPROD-index} (Kosmulski, 2007) for \eqn{x} is defined as
\deqn{MAXPROD(x)=\max\{i x_i: i=1,\dots,n\}}{MAXPROD(x)=max{i x_i: i=1,\dots,n}}
}
\details{
If a non-increasingly sorted vector is given, the function has O(n) run-time.

The MAXPROD index is the same as the discrete Shilkret integral of \code{x}
w.r.t. the counting measure.

See \code{\link{index_lp}} for a natural generalization.
}
\references{
Kosmulski M., MAXPROD - A new index for assessment of the scientific output
of an individual, and a comparison with the h-index,
\emph{Cybermetrics} 11(1), 2007.

Mesiar R., Gagolewski M., H-index and other Sugeno integrals:
   Some defects and their compensation,
 IEEE Transactions on Fuzzy Systems 24(6), 2016, pp. 1668-1672.
doi:10.1109/TFUZZ.2016.2516579

Gagolewski M., Mesiar R., Monotone measures and universal integrals
  in a uniform framework for the scientific impact assessment problem,
  Information Sciences 263, 2014, pp. 166-174. doi:10.1016/j.ins.2013.12.004

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other impact_functions: 
\code{\link{index_g}()},
\code{\link{index_h}()},
\code{\link{index_lp}()},
\code{\link{index_rp}()},
\code{\link{index_w}()},
\code{\link{pord_weakdom}()}
}
\concept{impact_functions}
